clear all


res=1000;%resolution
c=2.998e8;
Pump_PowerP=1; %in Watts
Pump_PowerQ=1;
A_eff=pi*(1e-6)^2;
n_2=2.34e-20;
Vector=ones(res,1);
Lambda = [0.775 0.920 1.2 1.55]; %Wavelength in microns
omega=w2f(Lambda);%frequencies of interest
n_NL=n_silica(Lambda);
Fibre_length=0.05;
Gamma=0.024;%(n_2*w2f(0.9))/(A_eff*c); %0.024 see Gorbach Opt Exp 14, 9854 (2006) perWatt per meter

varres=20;
Variation=0.01; %percentage design change to analyse
%% Fibre Designs


% Pitch=linspace(1,5,res); % In microns
% d_Pitch= linspace(0.4,0.7,10);
% 
% Zero_point=[];
% 
% for i=1:length(d_Pitch)
%     
%     Delta_Beta_Plot=[];
%     
%     for j=1:length(Pitch)
%         
%         n_eff=n_eff_SK(Lambda,d_Pitch(i),Pitch(j),n_NL);%saitoh and koshiba method for finding n_eff from V, U and Wparameters
%         Beta=n_eff.*omega/c;
%         Delta_Beta=Beta(4)+Beta(1)-Beta(2)-Beta(3)+(Gamma*(Pump_PowerQ-Pump_PowerP));
%         Delta_Beta_Plot=[Delta_Beta_Plot,Delta_Beta];
%         
%     end
%     
%     [zero,idx]=ZeroPoint_vec(Pitch,Delta_Beta_Plot,1);
%     Zero_point=[Zero_point,zero];
%     
% %     figure(1)
% %     plot(Pitch, Delta_Beta_Plot); 
% %     xlabel('Pitch [um]'); ylabel('Phase mismatch');
% %     title('Delta Beta');
% %     hold on
% 
% end
% % disp (d_Pitch)
% % disp (Zero_point)

        
%% Phasematching Plots

Pitch = 1.39;%input('Input pitch value')%pick one from the last section to look at more%
d_Pitch = 0.55;%input('Input d_pitch value')


Lambda_scan_pump=linspace(Lambda(2)-0.2,Lambda(2)+0.2,res);
Lambda_scan_source=linspace(Lambda(3)-0.2,Lambda(3)+0.2,res);


Lambda_Target=Lambda(4)*(Vector*Vector');%fixed target
Lambda_Q=Lambda_scan_pump.*Vector;%xaxis
Lambda_Source=(fliplr(Lambda_scan_source))'.*Vector';%yaxis

n_Target=n_eff_SK(Lambda_Target,d_Pitch,Pitch,n_silica(Lambda_Target)); 
n_Source=n_eff_SK(Lambda_Source,d_Pitch,Pitch,n_silica(Lambda_Source));
n_Q=n_eff_SK(Lambda_Q,d_Pitch,Pitch,n_silica(Lambda_Q));

omega_Target=w2f(Lambda_Target);
omega_Source=w2f(Lambda_Source);
omega_Q=w2f(Lambda_Q);

Beta_Target=n_Target.*omega_Target/c;
Beta_Source=n_Source.*omega_Source/c;
Beta_Q=n_Q.*omega_Q/c;

%Energy matching condition

Omega_P=-omega_Target+omega_Q+omega_Source;
Lambda_P=f2w(Omega_P);
n_P=n_silica(Lambda_P);
n_P_eff=(n_eff_SK(Lambda_P,d_Pitch,Pitch,n_P));
Beta_P=real(n_P_eff.*Omega_P/c);
Delta_omega=abs(Omega_P-omega_Source-omega_Q+omega_Target);

%Phasematching condition

Delta_Beta=(-Beta_Q-Beta_Source+Beta_Target+Beta_P)+(Gamma*(Pump_PowerQ-Pump_PowerP));
% Normalization_Coefficient_vec=max(Delta_Beta);
% Normalization_Coefficient=max(Normalization_Coefficient_vec);
SincBeta=abs(sin(Delta_Beta.*Fibre_length)./(Delta_Beta.*Fibre_length));

%  figure(2)
%  hold on
% % imagesc(Lambda_scan_pump,Lambda_scan_source,flipud(real(SincBeta)))
% % colormap(flipud(parula))
% % caxis([0.99999 1])
% 
%  contour(Lambda_scan_pump,fliplr(Lambda_scan_source)',Delta_Beta,[0 0],'b')
%   xlabel('Pump Q wavelength')
%   ylabel('Source wavelength')
% %title ('Pitch=1.78, d/Lambda=0.437 Target wavelength=1.55um')
%  contour(Lambda_scan_pump,fliplr(Lambda_scan_source)',Delta_omega,[0 0],'k')
% % line([0.639,0.639],[Lambda_min,Lambda_max])
% % line([Lambda_min,Lambda_max],[0.826,0.826])
% % line([1,1],[Lambda_min,Lambda_max])
% % line([Lambda_min,Lambda_max],[1.55,1.55])
% 
% figure(2)
% contour(Lambda_scan_pump,fliplr(Lambda_scan_source)',Lambda_P,[0.639 0.639],'r')

  

%% GVD

Lambda_scan=linspace(0.5,1.7,res);
Omega_scan=w2f(Lambda_scan);
n_scan=n_eff_SK(Lambda_scan,d_Pitch,Pitch,n_silica(Lambda_scan));

d_n_scan= diff(n_scan)./diff(Lambda_scan);									% dneff/dlambda

n_scan1=n_scan(:,1:end-1); %one entry smaller
Lambda_scan1=Lambda_scan(:,1:end-1); %one entry smaller
Omega_scan1 = 2*pi*c./Lambda_scan1;
n_group =  n_scan1- Lambda_scan1.*d_n_scan;
v_group= c./n_group;%Group velocity

Lambda_scan2 = Lambda_scan(:,1:end-2);										% New lambda vector with two fewer entries
Omega_scan2 = 2*pi*c./Lambda_scan2;

d2_n_scan = diff(d_n_scan)./diff(Lambda_scan1);								% d2neff/dlam
Dispersion = -1e18*(Lambda_scan2./c).*d2_n_scan;									% Dispersion parameter in ps/nm/km


figure(3)
plot(Omega_scan1,v_group);
set(gca, 'XDir','reverse')
ylabel ('Group velocity (Vg)')
xlabel ('Frequency (w)')
hold on
% 
% figure(4)
% plot(Lambda_scan2,Dispersion);
% hold on



%% group velocity additions
% 
% v_group_additional=v_group+1E5;
% n_group_additional=c./v_group_additional;
% delta_n_group= n_group-n_scan1;
% altered_n_eff=n_group_additional-delta_n_group; %tick
% 
% omega_altered=omega_Q(1:end-1,1:end-1);
% Beta_altered=real(altered_n_eff.*omega_altered/c);
% Beta_Target=Beta_Target(1:end-1,1:end-1);
% Beta_P=Beta_P(1:end-1,1:end-1);
% Beta_Target=Beta_Target(1:end-1,1:end-1);
% 
% Delta_Beta=(Beta_altered+Beta_Target-Beta_Target-Beta_P+(Gamma*(Pump_PowerQ-Pump_PowerP)));%+(2*Gamma*Pump_Power));Beta_980_matrix+Beta_source_matrix-Beta_target_matrix-Beta_pump_matrix
% Delta_Beta_Plot = rot90(fliplr(Delta_Beta),-1);
% figure(2)
% contour(Lambda_scan1,fliplr(Lambda_scan1)',Delta_Beta_Plot,[0 0],'r')



%% Fibre parameter variations

% Low_pitch= Pitch-(Variation*Pitch);
% High_pitch= Pitch+(Variation*Pitch);
% Pitch_vec=linspace(Low_pitch,High_pitch,varres);
% Low_d_pitch=d_Pitch-(Variation*d_Pitch);
% High_d_pitch=d_Pitch+(Variation*d_Pitch);
% d_Pitch_vec=linspace(Low_d_pitch,High_d_pitch,varres);
% Fibre_length=1; %in meters
% Percentvariation=linspace(-Variation,Variation,varres);
% 
% Lambda_P=linspace(Lambda(1)-0.05,Lambda(1)+0.05,res).*Vector;
% Omega_P=w2f(Lambda_P);
% n_P=n_silica(Lambda_P);
% Lambda_S=(fliplr(linspace(Lambda(3)-0.2,Lambda(3)+0.2,res)))'.*Vector';
% Omega_S=w2f(Lambda_S);
% n_S=n_silica(Lambda_S);
% 
% Intercept_Pitch=[];
% Intercept_dPitch=[];
% 
% for i=1:length(Pitch_vec)
% 
%     
%     n_eff_P=n_eff_SK(Lambda_P,d_Pitch,Pitch_vec(i),n_P);%saitoh and koshiba method for finding n_eff from V, U and Wparameters
%     Beta_P=n_eff_P.*Omega_P/c;
% 
%     n_eff_S=n_eff_SK(Lambda_S,d_Pitch,Pitch_vec(i),n_S);%saitoh and koshiba method for finding n_eff from V, U and Wparameters
%     Beta_S=n_eff_S.*Omega_S/c;
% 
%     Omega_Q=abs(Omega_P+omega_Target-Omega_S);
%     Lambda_Q=f2w(Omega_Q);
%     n_Q=n_silica(Lambda_Q);
%     n_Q_eff=(n_eff_SK(Lambda_Q,d_Pitch,Pitch_vec(i),n_Q));
%     Beta_Q=real(n_Q_eff.*Omega_Q/c);
%     Delta_K=Beta_P+Beta_Target-Beta_S-Beta_Q;
% 
%     C=contour(Lambda_P,(Lambda_S),Delta_K,[0 0]);
%     [M,idx]=min(abs(C(2,:)-1));
%     Intercept_Pitch=vertcat(Intercept_Pitch,[C(1,idx),C(2,idx)]);
% 
% end
% 
%   
%  for j=1:length(d_Pitch_vec)
%     
%     
%     n_eff_P=n_eff_SK(Lambda_P,d_Pitch_vec(j),Pitch,n_P);%saitoh and koshiba method for finding n_eff from V, U and Wparameters
%     Beta_P=n_eff_P.*Omega_P/c;
% 
%     n_eff_S=n_eff_SK(Lambda_S,d_Pitch_vec(j),Pitch,n_S);%saitoh and koshiba method for finding n_eff from V, U and Wparameters
%     Beta_S=n_eff_S.*Omega_S/c;
% 
%     Omega_Q=abs(Omega_P+omega_Target-Omega_S);
%     Lambda_Q=f2w(Omega_Q);
%     n_Q=n_silica(Lambda_Q);
%     n_Q_eff=(n_eff_SK(Lambda_Q,d_Pitch_vec(j),Pitch,n_Q));
%     Beta_Q=real(n_Q_eff.*Omega_Q/c);
%     Delta_K=Beta_P+Beta_Target-Beta_S-Beta_Q;
%     
% 
%     C=contour(Lambda_P,(Lambda_S),Delta_K,[0 0]);
%     [M,idx]=min(abs(C(2,:)-1));
%     Intercept_dPitch=vertcat(Intercept_dPitch,[C(1,idx),C(2,idx)]);
% 
%  end
% figure(3)
% xlabel('Design variation (%)')
% ylabel('Pump (P) wavelength')
% hold on
% plot(100*Percentvariation,Intercept_Pitch(:,1),'-*')
% plot(100*Percentvariation,Intercept_dPitch(:,1),'-*')

% = 
%% Cross phasematching
% figure(4)
% Pump_PowerP=linspace(1, 9, varres);
% Pump_PowerQ=10-Pump_PowerP;
% % Pump_ratio=Pump_PowerQ./Pump_PowerP;
% Intercept_XPM=[];
% 
% for i=1:varres
%     Delta_K= Delta_Beta +(Gamma*(Pump_PowerQ(i)-Pump_PowerP(i))*Fibre_length); 
%     C=contour(Lambda_scan_pump,fliplr(Lambda_scan_source)',Delta_K,[0 0]);
%     [M,idx]=min(abs(C(2,:)-1));
%     Intercept_XPM=vertcat(Intercept_XPM,[C(1,idx),C(2,idx)]);
% end
% 
% Omega_P= w2f(Intercept_XPM(:,1)) -omega(4) + omega(3);
% Lambda_P=f2w(Omega_P)-0.64;
% figure(5)
% xlabel('Pump (Q) Power')
% ylabel('Pump(P) wavelength')
% hold on
% plot(Pump_PowerQ,Lambda_P,'b')


